/*
 *  OPTypes.h
 *  The Obfuscated Path
 *
 *  Created by ss2cire on 12/6/08.
 *  Copyright 2008 GryphonClaw Software. All rights reserved.
 *
 */

typedef NSPoint OPPoint;
typedef NSSize OPSize;
typedef NSRect OPRect;

typedef enum
{
	OPLayerBackground,
	OPlayerObjects,
	OPLayerForeground
} OPLayer;

typedef enum 
{
	OPLeft,
	OPRight,
	OPUp,
	OPDown
} OPDirection;


#define OPMakeSize(w, h) NSMakeSize(w, h)
#define OPMakePoint(x, y) NSMakePoint(x, y)


#define OPMakeRect(x, y, w,h) NSMakeRect(x, y, w, h)


#define GAME_WIDTH (32*16)
#define GAME_HEIGHT (32*14)

#define ROOMWIDTH 16
#define ROOMHEIGHT 11

#define MAXIMUM_FRAME_RATE		60
#define MINIMUM_FRAME_RATE		15
#define UPDATE_INTERVAL			(1.0 / MAXIMUM_FRAME_RATE)
#define MAX_CYCLES_PER_FRAME	(MAXIMUM_FRAME_RATE / MINIMUM_FRAME_RATE)

#define NSPrettyLog(...) NSLog(@"%s: %@", __PRETTY_FUNCTION__, [NSString stringWithFormat: __VA_ARGS__])

#pragma mark ===== Notifications =====
extern NSString *OPSpawnEnemyNotification;
extern NSString *OPCreateItemNotification;
